// GRVcMngr.cpp: Implementierung der Klasse GRVoiceManager.
//
//////////////////////////////////////////////////////////////////////
/* Revision Control

$Header: C:\\RCS\\d\\saldvl\\noteview\\scorevc\\grphclrp\\grphclob\\grvcmngr.cpp,v 1.7 2002-10-29 21:39:30+01 renz Exp $ 

$Id: grvcmngr.cpp,v 1.7 2002-10-29 21:39:30+01 renz Exp $ 

$Log: grvcmngr.cpp,v $
Revision 1.7  2002-10-29 21:39:30+01  renz
Included \DrRenz tag for Kai's face ... now waiting for DrKilian :-)

Revision 1.6  2002-08-29 11:27:15+02  renz
Added RCS Headers
StaffManager now works with slices, this is reflected here, too
 

$Author: renz $ 

$Date: 2002-10-29 21:39:30+01 $ 

$Locker:  $ 

$Revision: 1.7 $ 

$Name:  $ 

$RCSfile: grvcmngr.cpp,v $ 

$Source: C:\\RCS\\d\\saldvl\\noteview\\scorevc\\grphclrp\\grphclob\\grvcmngr.cpp,v $ 

*/

#include <typeinfo>

#include "AbstrctR\AbstrctO\ARMsclvc.h"
#include "AbstrctR\AbstrctO\ARStaff.h"
#include "AbstrctR\AbstrctO\ARClef.h"
#include "AbstrctR\AbstrctO\ARTStem.h"
#include "AbstrctR\AbstrctO\ARMeter.h"
#include "AbstrctR\AbstrctO\ARBeam.h"
#include "AbstrctR\AbstrctO\ARChord.h"
#include "AbstrctR\AbstrctO\ARFerm.h"
#include "AbstrctR\AbstrctO\ARrngend.h"
#include "AbstrctR\AbstrctO\TagList.h"
#include "AbstrctR\AbstrctO\ARColor.h"
#include "AbstrctR\AbstrctO\ARCresc.h"
#include "AbstrctR\AbstrctO\ARDecres.h"
#include "AbstrctR\AbstrctO\ARSpace.h"
#include "AbstrctR\AbstrctO\ARAlter.h"
#include "AbstrctR\AbstrctO\ARNSystm.h"
#include "AbstrctR\AbstrctO\ARNPage.h"
#include "AbstrctR\AbstrctO\ARDiminu.h"
#include "AbstrctR\AbstrctO\ARDrHoos.h"
#include "AbstrctR\AbstrctO\ARDrRenz.h"
#include "AbstrctR\AbstrctO\ARBembel.h"
#include "AbstrctR\AbstrctO\ARDRngEn.h"
#include "AbstrctR\AbstrctO\ARRpBeg.h"
#include "AbstrctR\AbstrctO\ARRpEnd.h"
#include "AbstrctR\AbstrctO\ARRpEnRe.h"
#include "AbstrctR\AbstrctO\ARStaOff.h"
#include "AbstrctR\AbstrctO\ARDspDur.h"
#include "AbstrctR\AbstrctO\ARPBreak.h"
#include "AbstrctR\AbstrctO\ARPFormt.h"
#include "AbstrctR\AbstrctO\ARNKey.h"
#include "AbstrctR\AbstrctO\ARTuplet.h"
#include "AbstrctR\AbstrctO\ARSGlue.h"
#include "AbstrctR\AbstrctO\ARSysFrm.h"
#include "AbstrctR\AbstrctO\ARStfFrm.h"
#include "AbstrctR\AbstrctO\ARBarFrm.h"
#include "AbstrctR\AbstrctO\ARUnits.h"
#include "AbstrctR\AbstrctO\ARDtFrmt.h"
#include "AbstrctR\AbstrctO\ARNtFrmt.h"
#include "AbstrctR\AbstrctO\ARAccol.h"
#include "AbstrctR\AbstrctO\ARTitle.h"
#include "AbstrctR\AbstrctO\ARComp.h"
#include "AbstrctR\AbstrctO\ARStacc.h"
#include "AbstrctR\AbstrctO\ARMarc.h"
#include "AbstrctR\AbstrctO\ARAccent.h"
#include "AbstrctR\AbstrctO\ARTenuto.h"
#include "AbstrctR\AbstrctO\ARMark.h"
#include "AbstrctR\AbstrctO\ARFinger.h"
#include "AbstrctR\AbstrctO\ARLabel.h"
#include "AbstrctR\AbstrctO\AROctava.h"
#include "AbstrctR\AbstrctO\ARGrace.h"
#include "AbstrctR\AbstrctO\ARTrem.h"
#include "AbstrctR\AbstrctO\ARTrill.h"
#include "AbstrctR\AbstrctO\ARRit.h"
#include "AbstrctR\AbstrctO\ARAccel.h"
#include "AbstrctR\AbstrctO\ARInstr.h"
#include "AbstrctR\AbstrctO\ARFBar.h"
#include "AbstrctR\AbstrctO\ARAcc.h"
#include "AbstrctR\AbstrctO\ARABreak.h"
#include "AbstrctR\AbstrctO\ARAuto.h"
#include "AbstrctR\AbstrctO\ARBase.h"
#include "AbstrctR\AbstrctO\ARShrStm.h"
#include "AbstrctR\AbstrctO\ARShrLoc.h"
#include "AbstrctR\AbstrctO\ARTHead.h"
#include "AbstrctR\AbstrctO\ARChrdTg.h"
#include "AbstrctR\AbstrctO\ARUCrdTg.h"
#include "AbstrctR\AbstrctO\ARChrCom.h"


#include "GrphclRp\GrphclOb\GRVcMngr.h"
#include "GrphclRp\GrphclOb\GRStafmg.h"
#include "GrphclRp\GrphclOb\GRNFacto.h"
#include "GrphclRp\GrphclOb\GRClef.h"
#include "GrphclRp\GrphclOb\GRKey.h"
#include "GrphclRp\GrphclOb\GRTie.h"

#include "GrphclRp\GrphclOb\GRSlur.h"
#include "GrphclRp\GrphclOb\GRTag.h"
#include "GrphclRp\GrphclOb\GRMeter.h"
#include "GrphclRp\GrphclOb\GRCresc.h"
// #include "GrphclRp\GrphclOb\GRPCres.h"
#include "GrphclRp\GrphclOb\GRDiminu.h"
// #include "GrphclRp\GrphclOb\GRPDimin.h"
#include "GrphclRp\GrphclOb\GRBeam.h"
#include "GrphclRp\GrphclOb\GRABeam.h"
#include "GrphclRp\GrphclOb\GRSpace.h"
#include "GrphclRp\GrphclOb\GRText.h"
// #include "GrphclRp\GrphclOb\GRSText.h"
#include "GrphclRp\GrphclOb\GRDrHoos.h"
#include "GrphclRp\GrphclOb\GRDrRenz.h"
#include "GrphclRp\GrphclOb\GRBembel.h"
#include "GrphclRp\GrphclOb\GRRest.h"
#include "GrphclRp\GrphclOb\GRChord.h"
#include "GrphclRp\GrphclOb\GRTFerm.h"
// #include "GrphclRp\GrphclOb\GRFerm.h"
#include "GrphclRp\GrphclOb\GRTempo.h"
#include "GrphclRp\GrphclOb\GRSpecil.h"
#include "GrphclRp\GrphclOb\GRStdNth.h"
#include "GrphclRp\GrphclOb\GREmpty.h"
#include "GrphclRp\GrphclOb\GRMusic.h"
#include "GrphclRp\GrphclOb\GRtakstr.h"
#include "GrphclRp\GrphclOb\GRDBar.h"
#include "GrphclRp\GrphclOb\GRRpBeg.h"
#include "GrphclRp\GrphclOb\GRRpEnd.h"
#include "GrphclRp\GrphclOb\GRIntens.h"
#include "GrphclRp\GrphclOb\GRSngNot.h"
#include "GrphclRp\GrphclOb\GRSngRst.h"
#include "GrphclRp\GrphclOb\GRNTuplt.h"
#include "GrphclRp\GrphclOb\GRGlue.h"
#include "GrphclRp\GrphclOb\GRPgTxt.h"
#include "GrphclRp\GrphclOb\GRRange.h"
#include "GrphclRp\GrphclOb\GRArticu.h"
#include "GrphclRp\GrphclOb\GRGrace.h"
#include "GrphclRp\GrphclOb\GRTrem.h"
#include "GrphclRp\GrphclOb\GRTrill.h"
#include "GrphclRp\GrphclOb\GRAccel.h"
#include "GrphclRp\GrphclOb\GRRit.h"
#include "GrphclRp\GrphclOb\GRInstr.h"
#include "GrphclRp\GrphclOb\GRStem.h"
#include "GrphclRp\GrphclOb\GRFBar.h"
#include "GrphclRp\GrphclOb\GRDummy.h"

#include "GrphclRp\GrphclOb\GRGStem.h"
#include "GrphclRp\GrphclOb\GRGLoc.h"
#include "GrphclRp\GrphclOb\GRChrdTg.h"
#include "GrphclRp\GrphclOb\GRSysTag.h"
#include "GrphclRp\GrphclOb\GRSysSlc.h"



//////////////////////////////////////////////////////////////////////
// Konstruktion/Destruktion
//////////////////////////////////////////////////////////////////////

GRVoiceManager::GRVoiceManager(GRStaffManager *p_staffmgr,
							   ARMusicalVoice *p_voice,
							   int p_voicenum)
{
	toadd = NULL;
	curgrace = NULL;
	curglobalstem = NULL;
	curchordtag = NULL;
	curgloballocation  = NULL;
	curstemstate = NULL;
	curheadstate = NULL;
	staffmgr = p_staffmgr;
	arVoice = p_voice;
	voicenum = p_voicenum;
	curstaff = NULL;
	grvoice = curmusic->getVoice(arVoice);

	// nlinestate = NULL;
	// nlinegrtags = NULL;
	grtags = NULL;


	// stemstate = ARTStem::AUTO;

	lastev = NULL;

	curnoteformat = NULL;
	curdotformat = NULL;
	currestformat = NULL;

	lastbar = NULL;
	lastnonzeroevent = NULL;
}

GRVoiceManager::~GRVoiceManager()
{
	if (toadd)
		delete toadd;
	//if (nlinestate)
	//	delete nlinestate;
	if (grtags)
		delete grtags;
	//if (nlinegrtags)
	//	delete nlinegrtags;
	if (curvst)
		delete curvst;
}

// this routine parses those state tags,
// that are important for the voice-manager
// it retuns 1, if the tag was handled.
// otherwise, 0 is returned.
int GRVoiceManager::parseStateTag(ARMusicalTag *mtag)
{
	int retval = 1;

	ARStaff *mstaff;
	ARTStem *mstem;
	ARTHead *mhead;
	ARColor *mcolor;
	ARStaffFormat *staffrmt;
	ARBarFormat *barfrmt;
	ARNoteFormat *notefrmt;
	ARDotFormat *dotfrmt;
	ARRestFormat *restfrmt;
	ARABreak *arabreak;
	ARAuto *arauto;

	if ((mstaff = dynamic_cast<ARStaff *>(mtag))
			!= NULL)
	{
		// it is a staff-tag ...

		// then, the staff will be changed ....
		// the StaffManager (which is the owner
		// of this VoiceManager) is called; it
		// then prepares the staff ...
		staffnum = mstaff->getStaffNumber();
		staffmgr->prepareStaff(staffnum);
		curstaff = staffmgr->getStaff(staffnum);
		if (mstaff->getDY() && mstaff->getDY()->TagIsSet())
		{
			// what about staff-format and HS-values here?
			curstaff->setDistance(mstaff->getDY()->getValue());
		}
		ASSERT(curstaff);

		// staffmgr->setStaffNum(this,staffnum);

		/* removed the following: grnotefactory
		   no longer needed!
		// do I need this!? ->
		// A change in staff-state has to be calculated here!
		// grnotefactory->setGRStaff(curstaff);
		*/

	}
	else if ( (staffrmt = dynamic_cast<ARStaffFormat *>(mtag))
		!= NULL)
	{
		curstaff->setStaffFormat(staffrmt);
	}
	else if ( (barfrmt = dynamic_cast<ARBarFormat *>(mtag))
		!= NULL)
	{
		staffmgr->setBarFormat(barfrmt,curstaff);
	}
	else if ( (mstem = dynamic_cast<ARTStem *>(mtag))
		!= NULL)
	{
		// it is a stem-tag (stemsUp, stemsDown, stemsAuto)
		// stemstate = mstem->getStemState();
		curstemstate = mstem;

		/* this is no longer done, the
		   notefactory is no longer used ...
		int st = mstem->getStemState();
		if (st != ARTStem::OFF)
			grnotefactory->setStemOnOff(1);
		if (st == ARTStem::UP)
			grnotefactory->setStemDirection(1);
		else if (st == ARTStem::DOWN)
			grnotefactory->setStemDirection(-1);
		else if (st == ARTStem::OFF)
			grnotefactory->setStemOnOff(0);
		else
			grnotefactory->setStemDirection(0);
		*/
	}
	else if ( (mhead = dynamic_cast<ARTHead*>(mtag))
		!= NULL)
	{
		// the headstate ... 
		curheadstate = mhead;
	}
	else if ( (mcolor = dynamic_cast<ARColor *>(mtag))
		!= NULL)
	{
		// it is a color tag ...

		curcolor = RGB((int) mcolor->getColorR(),
			(int) mcolor->getColorG(),
			(int) mcolor->getColorB());
	}
	else if (typeid(*mtag) == typeid(class ARUnits))
	{
		// just ignore units tag ... (it is a state
		// tag after all ...)
	}
	else if ( (dotfrmt = dynamic_cast<ARDotFormat *>(mtag)) 
		!= NULL)
	{
		curdotformat = dotfrmt;
	}
	else if ( (notefrmt = dynamic_cast<ARNoteFormat *>(mtag)) 
		!= NULL)
	{
		curnoteformat = notefrmt;
	}
	else if ( (restfrmt = dynamic_cast<ARRestFormat *>(mtag)) 
		!= NULL)
	{
		currestformat = restfrmt;
	}
	else if ( (arabreak = dynamic_cast<ARABreak *>(mtag))
		!= NULL)
	{
			// we have an autoBreak-Tag set ...
			staffmgr->setAutoBreak(arabreak);

	}
	else if ( (arauto = dynamic_cast<ARAuto *>(mtag))
		!= NULL)
	{
			// we have an auto(set)-Tag set ...
			staffmgr->setAutoTag(arauto);

	}
	else
		retval = 0;

	return retval;

}

// this routine is called at the beginning of a
// management-Process. The VoiceManager initializes
// itself (time-Position, voice-state ...)
// the staff-number is the default-staff-number.
void GRVoiceManager::BeginManageVoice()
{
	// curtp = begintp;

	staffnum = arVoice->getVoiceNum();


	curcolor = RGB(0,0,0);

	// this is called only once ...!

	// this retrieves the current voice-state
	// (this is valid, if this is a "follow"-up
	// after a newSystem, or newPage-Tag)
	
	//old
	//if (arVoice->curVoiceState)
	//{
	//	curvst = arVoice->curVoiceState;
	//}
	//else
	//{
		curvst = new ARMusicalVoiceState();
		// the very first position ....
		arVoice->GetHeadPosition(*curvst);
	//}
	

		//old:
	// a possible nlinestate ....
	//nlinestate = new ARMusicalVoiceState(*curvst);


	/* actually, the NoteFactory is no longer needed;
	   all Elements in the voice have been "crushed",
	   so that they can be displayed by a single
	   graphical element.
	   Tuplets are also handled ...
    
	  // Jede Stimme hat eine Notefactory (im Prinzip ist
      // der Staffmanager der Besitzer der NoteFactory.
      grnotefactory = new GRNoteFactory();
	*/
	

    // Here, we define a Stack, that handles the TAGs. When a
    // Tag (e.g. the graphical representation of the Tag) is
	// on this tag, each Event (something that has a duration even
	// if it is 0) is
	// associated with it. (addAssociation is called). This ensures,
	// that the graphical representation "knows", which tags belong
	// to it.

	grtags = new GRTagPointerList();
	
	
	// the currently active tags can 
	// be accessed from the current voice-state
	
	// this is no longer needed, because there
	// is No Followup! -> This procedure is
	// called exactly one at the very beginning
	// At this point, there are NO StateTags
	// yet!

	/*
	// here, the current state tags are parsed
	// and the respective setting is set (either
	// in the voicemanager or in the staff ...)
	TagList *l = curvst->curstatetags;
	if (l)
	{
		POSITION mpos = l->GetHeadPosition();
		ARMusicalTag *mtag;
		while (mpos)
		{
			mtag = l->GetNext(mpos);
			// parseStateTag handles tags
			// like stemsUp, staff, color etc ..
			if (parseStateTag(mtag))
			{ 
				// returns !=0 if successful
				// tag was handled ...
			}
			// this routine is called for all
			// the state-tags that are important
			// for the staff (like clef, key, meter)
			// The StaffManager can display WARNINGS,
			// if a new meter or clef is set at
			// the same time-position (two cases:
			// 1. two tags in the same voice (meter .. meter)
			// 2. two tags (not matching) in different voices)
			else if (staffmgr->setStaffStateTag(mtag,staffnum))
			{
				// staffmgr returns !0 -> the 
				// Tag was handled.
			}
			else
			{
				WARNING("State-Tag could not be handled\n");
			}
			
		}  // while (mpos)
	}  // if (l) // taglist
	
	*/

	// we have to parse all the tags, that
	// handle state-information (like
	// pageformat,systemformat,staff etc...)
	ReadBeginTags(curvst->curtp);


	// The StaffManager handles all staves in a list ...
	staffmgr->prepareStaff(staffnum);

	curstaff = staffmgr->getStaff(staffnum);
	ASSERT(curstaff);

	// definitily not needed any longer 
	// (now that we use GSNF (Guido Semantic Normal Form)
	// Don't know, wether I need this - probably ...
	// no longer needed 
	// grnotefactory->setGRStaff(curstaff);

	// curstaff->setTagList(grtags);

	// these are the positiontags that
	// are open now 

	// Note: we can be sure, that in each case,
	// there is a TAG at the current position
	// (either we are at the beginning of the voice,
	// then there must be at least a clef introduced;
	// if we are in continuation, a clef has been
	// introduces as well in 
	// ARMusicalVoice::doAutoCheckStaffStateTags)

	// this means, that all curpositiontags are
	// are "open" ones, that is, they have not
	// just been started.

	// just ignore this: this procedure is only
	// called once. There are NO OPEN TAGS!

	/*
	if (curvst->curpositiontags != NULL)
	{
		// This asks for the current state of the Tags ...
		const PositionTagList *tl = curvst->curpositiontags;
		
		POSITION pos = tl->GetHeadPosition();
		openLeftRange = 1;
		while (pos)
		{	
			ARPositionTag *apt = tl->GetNext(pos);


			// this is old (we can really 
			// ASSURE, that all positiontags
			// are "old" ones):
			// only those tags are parsed, that do
			// NOT have matching Start-Positions ...
			// this is done, so that no StartTags
			// are Parsed twice ...

			ASSERT(apt->getStartPosition() != curvst->vpos);
			ASSERT(arVoice->GetAt(curvst->vpos)->getRelativeTimePosition()
				< begintp);


	
			//if (apt->getStartPosition() != curvst->vpos
			//	|| arVoice->GetAt(curvst->vpos)->getRelativeTimePosition() 
			//	< begintp)
			
			   parsePositionTag( apt );
			// note that parePositionTag knows about
			// the openleftrange
		}

		openLeftRange = 0;
	} */



	// what are these?
	// obiously they are not needed any more ...

	// just ignore this ...
	/*
	if (curvst->curtags != NULL)
	{
		ASSERT(FALSE);

		// This asks for the current Tags ...
		TagList *tl = curvst->curtags;
		
		POSITION pos = tl->GetHeadPosition();
		openLeftRange = 1;
		while (pos)
		{	
			ARMusicalTag *mtag = tl->GetAt(pos);
			parseTag( dynamic_cast<ARMusicalObject *>(mtag) );
			tl->RemoveElement(mtag);
			tl->GetNext(pos);
		}
		openLeftRange = 0;
	}
	*/

	// Adds all the Position tags, that are active
	// right now.
	// addStartPTags();
	// is equivalent!

/*	this is done inbetween ....
	if (curvst->curpositiontags != NULL)
	{
		const PositionTagList *tl = curvst->curpositiontags;
		POSITION pos = tl->GetHeadPosition();
		openLeftRange = 1;
		while (pos)
		{
			parsePositionTag( tl->GetNext(pos) );
		}
		openLeftRange = 0;
	} */


	// delete mvs; // muss geloescht werden !

	// This has been replaced by getMusicalVoiceState
	//  int stems = arVoice->getStemAtTimePosition(
	//			relativeTimePositionOfGR);

	// ACHTUNG: ich glaube, dass folgende ist falsch! Das Tuplet hat
	// nichts mit dem Staff zu tun!
	// Jetzt wird der Notenfactory mitgeteilt, ob es Tuplets gibt

	// Handle tuplets in the Voice-State!!!!
//	if (curstaff->mystate.tupletset)
//	{
//		grnotefactory->setTupletState(curstaff->mystate.tplstate);
//	}



	// Bestimme, ob Schluessel gesetzt werden muessen ...

	/* if (curstaff->mystate.clefset == GRStaffState::CLEFINTERN  ||
		 curstaff->mystate.clefset == GRStaffState::CLEFEXPLICIT )
	{ // d.h. expliziter oder impliziter CLEF

		ARClef * arclef = new ARClef(curstaff->mystate.clefname);
		arclef->setRelativeTimePosition(curtp);
		GRClef * grclef = new GRClef(arclef,1); // ownsAR, d.h. wird auch
													// richtig geloescht!
		curstaff->elements->AddHead((GRNotationElement *)grclef);
	} */

/* Das Meter wird nur in der ersten Zeile dargestellt (oder bei
	Taktwechsel. Deshalb sind die folgenden Zeilen falsch!)

	if (curstaff->mystate.meterset == TRUE)
		{
		// Meter ist gesetzt -> also wird ein Meter erzeugt.
		ARMeter *armeter = new ARMeter(curstaff->mystate.measurelength.getNumerator(),
					curstaff->mystate.measurelength.getDenominator());
		armeter->setRelativeTimePosition(relativeTimePositionOfGR);
		GRMeter *grmeter = new GRMeter(armeter,1);
		elements->AddTail((GRNotationElement *) grmeter);
		}
*/

	// ACHTUNG: was passiert, wenn an dieser Position keine Noten stehen ...
	// wird dann gar nichts gemacht? -> Bekommt alle Noten/Pausen, die an dieser
	// Stelle stehen, d.h. auch laufende, d.h. zu dieser Zeit aktive Noten/Pausen!


	// Cut am Staff-Anfang, d.h. das entsprechende Element beginnt eigentlich
	// vor dem Beginn des Staff
	//if(curvst->vpos && arVoice->GetAt(curvst->vpos)->getRelativeTimePosition()<
	//	staffmgr->getRelativeTimePositionOfGR())
	// {
		
		/*  Rethink all this!
		
		// der Parameter hastoadd beschreibt, ob ein Tie gezeichnet werden muss
		int hastoadd = 0;
		arObject=arVoice->GetNext(curvst->vpos,*curvst); // GetNext holt das Element an der Position
										// und schaltet dann pos weiter.
		if(arObject->getRelativeEndTimePosition()<=staffmgr->getRelativeEndTimePosition())
		{  // das Objekt endet vor oder beim Ende des Staffs
			cutDuration=arObject->getRelativeEndTimePosition()-staffmgr->getRelativeTimePositionOfGR();
		}
		else // Staff ist so kurz, dass es sogar auch einen Cut am Staff-Ende gibt!
		{
			cutDuration=staffmgr->getRelativeEndTimePosition()-staffmgr->getRelativeTimePositionOfGR();
			hastoadd = 1;
		}
		// Erzeuge die Note
		
		// direct call of grnotefactory etc ....

		GRNote *last = curstaff->createCutStaffElement(arObject,staffmgr->getRelativeTimePositionOfGR(),
				cutDuration,grnotefactory);
		if (last)
		{ // ein Halber Tie am Anfang muss eh gesetzt werden ...
			GRTie *tie = new GRTie(NULL,last);
			last->addAssociation(tie);
			curstaff->elements->AddTail(tie);
		}
		if (hastoadd && last)
		  { // es muss ein halber Haltebogen erzeugt werden.
		  GRTie *tie = last->AddHalfTie();
		  curstaff->elements->AddTail(tie);
		  }

		// Hier muss man sich was ueberlegen mit TeilBindeboegen ueber
		// Staff-Grenzen!

		*/
	// }


}
/* Bearbeitet eine Stimme. Die einzelenen Events werden auf
 * die Staffs verteilt.
 */
/* void GRVoiceManager::ManageVoice(int n)
{

	
	POSITION pos=arVoice->getPosAtTimePosition(tp);

	// checks for the Voice-State and sets
	// all relevant parameters
	BeginManageVoice(tp,n);

	ARMusicalObject *arObject;
	TYPE_TIMEPOSITION curtp = tp;

	int ret = 1;
	// keine Cuts im Staff, bis auf aktuelle Meter und Bar-geschichten
	while(pos && 
		  ret==1 &&
		  arVoice->GetAt(pos)->getRelativeEndTimePosition()
			<=staffmgr->getRelativeEndTimePosition())
	{
		ret = ManageVoicePosition(pos,curtp);
	} // while(pos && arVoice->GetAt(pos)->getRelativeEndTimePosition()
	  //  <=getRelativeEndTimePosition())

	// ret==-1 is set, when a newLine-Tag is
	// encountered.
	// ret==-2 is set, when a newPage-Tag is
	// encountered
	if (ret == -1)
	{
		staffmgr->EndSystem(arVoice,pos);
	}
	else if (ret == -2)
	{
		staffmgr->EndPage(arVoice,pos);
	}
	

	EndManageVoice(pos);

} */

// this routine actually does a newSystem or a
// newPage-break.
// if the tag at the current position is a 
// newSystem or a newPage-Tag, than the position
// is incremented.
int GRVoiceManager::DoBreak(const TYPE_TIMEPOSITION &tp,
							int system_or_page)
{
	if (curvst->curtp > tp)
	{
		// in the middle of an event!
		ASSERT(FALSE);
		// this can not be, because
		// breaks are only done at
		// positions, that are inbetween
		// events.
	}
	else if (curvst->curtp < tp)
	{
		// then we have a problem
		ASSERT(FALSE);
	}

	ARMusicalObject *o = NULL;
	if (curvst->vpos)
		o = arVoice->GetAt(curvst->vpos);


	if (o && dynamic_cast<ARPossibleBreak *>(o))
	{
		arVoice->GetNext(curvst->vpos,*curvst);
	}
	else if ( o && dynamic_cast<ARNewSystem *>(o))
	{
		arVoice->GetNext(curvst->vpos,*curvst);
	}
	else if (o && dynamic_cast<ARNewPage *>(o))
	{
		arVoice->GetNext(curvst->vpos,*curvst);
	}



	// newSystem or newPage
	// we need to get a new curstaff ...
	// This automatically adds the startglue 
	if (system_or_page == 1 || 
		system_or_page == 2)
	{

		// now, we need to handle the break within
		// the voice, so that rod-creation works ...
		grvoice->lastrod = NULL;
		// looking for newlines ...
		grvoice->isnewline = 1;
		grvoice->firstPositionInLine = NULL;

		grvoice->lastsprpos = NULL;

		// now we have to read the begintags ...
		// this ensures, that the staff-Tag is read
		// right after a newSystem-tag
		// and also the \pageFormat-Tag after a \newPage
		// tag. Then, the necessary steps can be taken by
		// the StaffManager/VoiceManager etc....
		ReadBeginTags(curvst->curtp);

		staffmgr->prepareStaff(staffnum);
		curstaff = staffmgr->getStaff(staffnum);

		// this adds the two start glues ....
		curstaff->BeginStaff(staffmgr);

		ASSERT(curstaff);

		curtp = curvst->curtp;
		// than we can handle the openTags ...
		beginOpenTags();

		lastbar = NULL; // there is no barline !
		lastnonzeroevent = NULL; // and no nonzeroevent ....


	}
	else if (system_or_page == 3)
	{
		// we are now working with slices ....
		curstaff = staffmgr->getStaff(staffnum);

	}

	return 1;
}

// Iterate iterates through the voice.
// dependant on the timeposition and filltagmode
// different behaviour occurs:
// if curtp>tp then tp is set to curtp and 
// CURTPBIGGER_ZEROFOLLOWS or 
// CURTPBIGGER_EVFOLLOWS is returned.
// if curtp<tp ASSERT(FALSE) is done.
// if we are at the end of the voice, 
// ENDOFVOICE is returned
// dependant on filltagmode:
// filltagmode == 1 -> 
// if curtag==newSystem/newPage, NEWSYSTEM 
//    or NEWPAGE is returned
// if there are tags or events with dur==0
// at the current VoicePosition, than the
// respective NotationElements are
// created (tags that do not have
// a graphical representation are also 
// parsed one after another anyway -> 
// to optimize, one could introduce an internal 
// loop here...) and DONE_ZEROFOLLOWS,
// DONE_EVFOLLOWS or DONE is returned
// (when the next element is a tag DONE_ZEROFOLLOWS
//  is returned. If the next element is an event
//  then DONE_EVFOLLOWS is returned. If there
//  is no next element DONE is returned).
// if there is an event with dur>0
// than MODEERROR is returned.
// filltagmode == 0:
// if there is an event at curtp then
// the GRNotationElement is created,the 
// curtp is incremented; DONE_ZEROFOLLOWS
// DONE_EVFOLLOWS or DONE is returned
// (dependant on next element).
// if there is no event here, than ASSERT(FALSE)
// is done (because this is not allowed to happen;
// otherwise, other voices could have progressed
// past the currentTP without handling Tags in 
// a proper way).
int GRVoiceManager::Iterate(TYPE_TIMEPOSITION &tp,
							int filltagmode)
{
	if (curvst->vpos == NULL)
		return ENDOFVOICE;

	if (curvst->curtp > tp)
	{
		tp = curvst->curtp;
		ARMusicalObject *o =
			arVoice->GetAt(curvst->vpos);
		if (o->getDuration() == 0)
			return CURTPBIGGER_ZEROFOLLOWS;
		return CURTPBIGGER_EVFOLLOWS;

	}
	if (curvst->curtp < tp)
	{
		ASSERT(FALSE);
	}


	if (filltagmode)
	{
		ARMusicalObject *o = arVoice->GetAt(curvst->vpos);
		ARNewSystem *tmp;
		if ( (tmp = dynamic_cast<ARNewSystem *>(o)) != NULL)
		{
			if (tmp->getDY() && tmp->getDY()->TagIsSet())
			{
				// then we have a distance to the next system ...
				staffmgr->setSystemDistance(tmp->getDY()->getValue(
					curstaff->getStaffLSPACE()),
					*this);
				
			}
			return NEWSYSTEM;
		}
		else if (dynamic_cast<ARNewPage *>(o))
		{
			return NEWPAGE;
		}
		else if (dynamic_cast<ARPossibleBreak *>(o))
		{
			pbreakval = dynamic_cast<ARPossibleBreak *>(o)->value;
			return PBREAK;
		} 

		if (o->getDuration() == DURATION_0)
			
		{
			// now we have a tag ( no position tag!)
			// or an event with duration 0
			// handle it ...

			GRNotationElement *grne = NULL;

			if (dynamic_cast<ARMusicalEvent *>(o))
			{
				// Then we create an EMPTY-Event
				// handling all the startPTags
				// and endPTags ...
				checkStartPTags(curvst->vpos);
				
				GREvent *ev = NULL;
				if (curgrace)
				{
					// then we have to create
					// a GRACE-Note
					// (which is a real note,
					//  no duration but
					//  somewhat drawn aswell ...
					//  the associations are set
					//  regardless ...)

					// this must be the parameter
					// from ARGrace ...

					// check, wether this is an empty-event anyhow ....
					
					// ASSERT(curvst->curdispdur);
					TYPE_DURATION dur = o->getDuration();
					if (curvst->curdispdur)
						dur = curvst->curdispdur->getDisplayDuration();

					ev = CreateGraceNote(tp,o,dur);
	
					// this adds the Grace-Note as a regular
					// event ...
					if (ev->getNeedsSpring() == -1)
					{
						// then I need the springID of
						// curglobalstem or curgloballocation
						GRNotationElement *firstEl = NULL;
						if (curgloballocation || curglobalstem)
						{

							if (curgloballocation)
								firstEl = curgloballocation->getFirstEl();
							else
								firstEl = curglobalstem->getFirstEl();
						}
						staffmgr->AddGRSyncElement(ev,
							curstaff,firstEl->getSpringID(),grvoice,firstEl);

					}
					else
					{
						staffmgr->AddGRSyncElement(ev,
							curstaff,voicenum,grvoice);
					}


					// if (ev) curgrace->AddTail(ev);

				}
				else
				{
					// carful, what happens to dispDur!!!!
					if (curvst->curdispdur != NULL &&
						curvst->curdispdur->getDisplayDuration() 
						> DURATION_0)
					{
						if (dynamic_cast<ARNote *>(o))
						{
							ev = CreateNote(tp,o);
						}
						else if (dynamic_cast<ARRest *>(o))
						{
							ev = CreateRest(tp,o);
						}
						else if (dynamic_cast<ARChord *>(o))
						{
							ev = CreateChord(tp,o);
						}
					}
					else
						ev = CreateEmpty(tp,o);
					

					if (ev->getNeedsSpring() == -1)
					{
						// then I need the springID of
						// curglobalstem or curgloballocation
						GRNotationElement *firstEl = NULL;
						if (curgloballocation || curglobalstem)
						{

							if (curgloballocation)
								firstEl = curgloballocation->getFirstEl();
							else
								firstEl = curglobalstem->getFirstEl();
						}
						staffmgr->AddGRSyncElement(ev,
							curstaff,firstEl->getSpringID(),grvoice,firstEl);

					}
					else
					{
						staffmgr->AddGRSyncElement(ev,
							curstaff,voicenum,grvoice);
					}
				}

				POSITION prevpos = curvst->vpos;
				
				// increment the curvoice ...
				// increment the position ...
				arVoice->GetNext(curvst->vpos,*curvst);
				
				// Check Ending Tags ...
				if (curvst->removedpositiontags)
				{
					checkEndPTags(prevpos);
				}
				
				
				if (curvst->vpos)
				{
					// check, what the
					// next element in the voice
					// is (tag, zero-event or event)
					ARMusicalObject *o =
						arVoice->GetAt(curvst->vpos);
					if (o->getDuration() == 0)
						return DONE_ZEROFOLLOWS;
					ASSERT(dynamic_cast<ARMusicalEvent *>(o));
					return DONE_EVFOLLOWS;
				}
				return DONE;
				
				
			}
			else if ((grne = parseTag(o)) != NULL)
			{
				// tag was handled ....

				// this is NEW (January/Feb 2000)
				// Here, we distinguish the different
				// graphical TAG-Types

				GRTag *tag = dynamic_cast<GRTag *>(grne);
				if (tag && 
				   (tag->getTagType() == GRTag::SYSTEMTAG))
				{
					staffmgr->AddSystemTag(grne,curstaff,voicenum);
				}
				else if (tag &&
					(tag->getTagType() == GRTag::PAGETAG))
				{
					staffmgr->AddPageTag(grne,curstaff,voicenum);
				}
				else if (grne->getNeedsSpring())
				{
					if (curglobalstem || curgloballocation)
					{
						TRACE("Tag with spring in a globalstem or "
							"global location!\n");
						// The tag is no longer added but
						// gets associated with
						// the curglobalthing that
						// is active at that point ...

						GRNotationElement *firstEl = NULL;
						if (curgloballocation)
						{
							firstEl = curgloballocation->getFirstEl();
						}
						else if (curglobalstem)
						{
							ASSERT(curglobalstem);
							firstEl = curglobalstem->getFirstEl();
						}

						grne->setNeedsSpring(-1);
						staffmgr->AddGRSyncElement(grne,
							curstaff,firstEl->getSpringID(),grvoice,
							firstEl);

						/* if (curgloballocation)
						{
							curgloballocation->addAssociation(grne);
						}
						else if (curglobalstem)
						{
							ASSERT(curglobalstem);
							curglobalstem->addAssociation(grne);
						} */
					}
					else
					{
					staffmgr->AddGRSyncElement(grne,
						curstaff,voicenum,grvoice);
					}

				}

			}
			else
			{
				// not handled!?
				ARMusicalTag *armt = dynamic_cast<ARMusicalTag *>(o);
				if (!armt || !armt->IsStateTag())
					TRACE("Warning, Tag not handled\n");
			}


			// increment the position ...
			arVoice->GetNext(curvst->vpos,*curvst);

			if (curvst->vpos)
			{
				// check, what the
				// next element in the voice
				// is (tag, zero-event or event)
				ARMusicalObject *o =
					arVoice->GetAt(curvst->vpos);
				if (o->getDuration() == 0)
					return DONE_ZEROFOLLOWS;
				ASSERT(dynamic_cast<ARMusicalEvent *>(o));
				return DONE_EVFOLLOWS;
			}
			return DONE;

		}
		else
		{
			// duration > 0,
			return MODEERROR;
		}

	}
	else
	{
		// filltagmode == 0
		ARMusicalObject *o = arVoice->GetAt(curvst->vpos);
		if (o->getDuration() == DURATION_0)
		{
			ASSERT(FALSE);
			// This MUST not happen, because then,
			// other voices can already have
			// progressed ...
			// return MODEERROR;
		}
		else
		{
			// handle the event ...
			
			
			ARMusicalEvent *arev = dynamic_cast<ARMusicalEvent *>(o);
			
			// This creates the graphical
			// Representation for position-tags, that
			// start at the current position ...
			checkStartPTags(curvst->vpos);
			
			GREvent *grev = NULL;
			if (dynamic_cast<ARNote *>(arev))
			{
				grev = CreateNote(tp,arev);
			}
			else if (dynamic_cast<ARRest *>(arev))
			{
				grev = CreateRest(tp,arev);
			}
			else if (dynamic_cast<ARChord *>(arev))
			{
				grev = CreateChord(tp,arev);
			}
			else
			{
				ASSERT(FALSE);
			}
			
			ASSERT(grev);

			if (grev->getDuration() > DURATION_0)
			{
				lastnonzeroevent = grev;
			}
			

			if (toadd && toadd->GetCount() > 0)
			{
				POSITION mypos = toadd->GetHeadPosition();
				while (mypos)
				{
					GRNotationElement * el =
						dynamic_cast<GRNotationElement *>
						(toadd->GetNext(mypos));
					el->addAssociation(grev);
					grev->addAssociation(el);
					
				}
				toadd->RemoveAll();
			}
	
			
			if (grev->getNeedsSpring() == -1)
			{
				// then I need the springID of
				// curglobalstem or curgloballocation
				GRNotationElement *firstEl = NULL;
				if (curgloballocation || curglobalstem)
				{
					
					if (curgloballocation)
						firstEl = curgloballocation->getFirstEl();
					else
						firstEl = curglobalstem->getFirstEl();
				}
				staffmgr->AddGRSyncElement(grev,
					curstaff,firstEl->getSpringID(),grvoice,firstEl);
				
			}
			else
			{
				staffmgr->AddGRSyncElement(grev,
					curstaff,voicenum,grvoice);
			}
			
			
			// set the duration/timeposition ...!
			
			// important: take the AR-Representation
			// here, as the graphical is dependant
			// on the display-Duration-Setting.
			tp = arev->getRelativeEndTimePosition();
			
			POSITION prevpos = curvst->vpos;
				
			// increment the curvoice ...
			// increment the position ...
			arVoice->GetNext(curvst->vpos,*curvst);
			
			// Check Ending Tags ...
			if (curvst->removedpositiontags)
			{
				checkEndPTags(prevpos);
			}
			
			if (curvst->vpos)
			{
				// check, what the
				// next element in the voice
				// is (tag, zero-event or event)
				ARMusicalObject *o =
					arVoice->GetAt(curvst->vpos);
				if (o->getDuration() == 0)
					return DONE_ZEROFOLLOWS;
				ASSERT(dynamic_cast<ARMusicalEvent *>(o));
				return DONE_EVFOLLOWS;
			}
			return DONE;
		}
		
	}

}

// returns 1 if Element was added.
// returns -1 if newLine was encountered
// returns -2 if newPage was encountered
// returns -5 if staffOff was encountered
// returns 0 if TimePosition is too short
// returns -3 if End of Voice
// returns -4 if something else went wrong

// changeds tp to the next available TimePosition
//DEL int GRVoiceManager::Next(TYPE_TIMEPOSITION &tp)
//DEL {
//DEL 	// OLD:
//DEL 
//DEL 	ASSERT(FALSE);
//DEL 	if (curvst->vpos == NULL)
//DEL 	{
//DEL 		tp = curtp;
//DEL 		return -3; // we are at the End ...
//DEL 	}
//DEL 
//DEL 	if (curtp>tp)
//DEL 	{
//DEL 		// no need to do anything ... 
//DEL 		// the current voice time is ahead of the
//DEL 		// System-time ...
//DEL 		// This is only relevant, when linebreaks
//DEL 		// are encountered and Notes/Rests need to
//DEL 		// split.
//DEL 
//DEL 		// Remind the manager of the next available
//DEL 		// timeposition ...
//DEL 
//DEL 		tp = curtp;
//DEL 		return 0;
//DEL 	}
//DEL 
//DEL 	int retval = 1;
//DEL 	int ret;
//DEL 	// this loop runs, until the timeslice has
//DEL 	// advanced, or end of Voice has been 
//DEL 	// encountered
//DEL 	do
//DEL 	{
//DEL 		// now we manage the voice position.
//DEL 
//DEL 		// during this call, the Rods have to be 
//DEL 		// created ...
//DEL 		ret = ManageVoicePosition(tp);
//DEL 		
//DEL 		if (curvst->vpos == NULL)
//DEL 		{
//DEL 			// now, we are at the end.
//DEL 			retval = -3;
//DEL 		}
//DEL 
//DEL 		if (ret == 1)
//DEL 		{
//DEL 			// all is OK, position was managed and
//DEL 			// added to the curstaff
//DEL 		
//DEL 			// curvst->vpos has been advanced
//DEL 
//DEL 			// this is the time of the next event 
//DEL 
//DEL 			// check the real timeposition of the last
//DEL 			// graphicalelement!
//DEL 			curtp = curstaff->getElements()->GetTail()->getRelativeEndTimePosition();
//DEL 			// curtp = arVoice->GetAt(curvst->vpos)->getRelativeTimePosition();
//DEL 		}
//DEL 
//DEL 		else if (ret == -1 || ret == -2 ||ret == -5)
//DEL 		{
//DEL 			// newLine-Tag or newPage-Tag
//DEL 			// or staffOff
//DEL 
//DEL 			// curvst->vpos has been advanced ...
//DEL 
//DEL 			// this is the time of the next event after
//DEL 			// the newLine or newPage-Tag
//DEL 			if (curvst->vpos == NULL)
//DEL 			{
//DEL 				curtp = arVoice->getRelativeEndTimePosition();
//DEL 
//DEL 			}
//DEL 			else
//DEL 			curtp = arVoice->GetAt(curvst->vpos)->getRelativeTimePosition();
//DEL 
//DEL 			// set the time to the next timeslot.
//DEL 			tp = curtp;
//DEL 
//DEL 			return ret;
//DEL 		}
//DEL 	}
//DEL 	while ((ret == 1 || ret == 0) && curtp== tp);
//DEL 
//DEL 	if (ret == 1)
//DEL 	{
//DEL 		tp = curtp;
//DEL 		return retval;
//DEL 	}
//DEL 
//DEL 
//DEL 	// some error?
//DEL 	return -3;
//DEL 
//DEL }

// returns 1 if everything is OK (meaning, things should
// go on)
// Position is forwarded to the next position.
// returns 0 if staff-line became to crowded
// returns -1 if newLine was encountered
// returns -2 if newPage is encountered
// returns -5 if staffOff is encountered
//
// The timeposition (tp) is important to determine,
// wether we are in the middle of an event ...
//DEL int GRVoiceManager::ManageVoicePosition(const TYPE_TIMEPOSITION &tp)
//DEL 										 
//DEL {
//DEL 	int retval = 0;
//DEL 
//DEL 
//DEL 	// the current position within the voice.
//DEL 
//DEL 	POSITION pos = curvst->vpos;
//DEL 
//DEL 	if (!pos) return -3;
//DEL 	
//DEL 	// it is important to look at times:
//DEL 	// it could be, that we are in the
//DEL 	// Middle of an event ...
//DEL 
//DEL 	ARMusicalObject *arObject = arVoice->GetAt(pos);
//DEL 	TYPE_TIMEPOSITION artp = 
//DEL 		arObject->getRelativeTimePosition();
//DEL 	// TYPE_TIMEPOSITION aretp = 
//DEL 	// arObject->getRelativeEndTimePosition();
//DEL 
//DEL 	TYPE_TIMEPOSITION von = tp;
//DEL 	TYPE_DURATION     bis = arObject->getDuration();
//DEL 
//DEL 	// this defines, wether objects should be broken
//DEL 	// up at measure-boundaries.
//DEL 	int measurebreak = 1;
//DEL 
//DEL 	ARNote *arnote = dynamic_cast<ARNote *>(arObject);
//DEL 	if (arnote)
//DEL 	{
//DEL 		if (arnote->getPitch() == EMPTY)
//DEL 		{
//DEL 			measurebreak = 0;
//DEL 		}
//DEL 	}
//DEL 
//DEL 	int inmiddle = 0;
//DEL 
//DEL 	if (artp < tp)
//DEL 	{
//DEL 
//DEL 		// this should not happen any
//DEL 		// longer.
//DEL 		ASSERT(FALSE);
//DEL 
//DEL 		// we are in the middle of an event
//DEL 		// the duration is adjusted.
//DEL 
//DEL 		// Ties should be added at this point ....
//DEL 
//DEL 		bis = artp + bis - tp;
//DEL 
//DEL 		inmiddle = 1;
//DEL 
//DEL 	}
//DEL 	else if (artp == tp)
//DEL 	{
//DEL 		// add PositionTags if necessary ....
//DEL 
//DEL 		// we are at this position for the first time!
//DEL 		checkStartPTags(pos);
//DEL 	}
//DEL 	else
//DEL 	{
//DEL 		// this should definitly not happen
//DEL 		ASSERT(FALSE);
//DEL 	}
//DEL 
//DEL 	int lastendofmeasure = 0;
//DEL 	int beginofmeasure = 0;
//DEL 
//DEL 
//DEL 	// should not be needed any longer:
//DEL 	// (because of GUIDO Semantic Normal Form)
//DEL 
//DEL 	/*
//DEL 	// now adjust the length of the notes,
//DEL 	// so that they do not interfer with the
//DEL 	// current meter!
//DEL 	if (curstaff->mystate.meterset == TRUE 
//DEL 		&& (von + bis) >= curstaff->mystate.nextmeasuretime
//DEL 		&& measurebreak == 1)
//DEL 	{
//DEL 
//DEL 		bis = curstaff->mystate.nextmeasuretime - von;
//DEL 		lastendofmeasure = 1;
//DEL 	}
//DEL 	if (curstaff->mystate.meterset == TRUE
//DEL 		&& von == curstaff->mystate.nextmeasuretime
//DEL 			- curstaff->mystate.measurelength)
//DEL 	{
//DEL 		beginofmeasure = 1;
//DEL 	}
//DEL 	*/
//DEL 
//DEL 
//DEL 
//DEL #ifdef __VC50__
//DEL #define __VC40_MFC
//DEL #endif
//DEL 
//DEL #ifdef __VC40_MFC
//DEL 	const type_info& ti=typeid(*arObject);
//DEL #else
//DEL 	const typeinfo& ti = typeid(*arObject);
//DEL #endif
//DEL 
//DEL #ifdef __VC50__
//DEL #undef __VC40_MFC
//DEL #endif
//DEL 
//DEL 	lastev = NULL;
//DEL 
//DEL 	if (ti == typeid(class ARNote))
//DEL 	{
//DEL 		ARNote *arnote = dynamic_cast<ARNote *>(arObject);
//DEL 
//DEL 		// this is not quite clear yet
//DEL 		if (bis <= DURATION_0)
//DEL 		{
//DEL 			// we have an error ...
//DEL 			// ASSERT(FALSE);
//DEL 		}
//DEL 		else if (arnote->getPitch() == EMPTY)
//DEL 		{
//DEL 			// we ignore this ...
//DEL 			// now we add a GREmpty-Event ...
//DEL 
//DEL 			// if the notefactory has a tuplet right now,
//DEL 			// it needs to be finished.
//DEL 
//DEL 			//GRTupletState tplstate;
//DEL 			//grnotefactory->finish(tplstate);
//DEL 
//DEL 			GREmpty *grempty = new GREmpty(curstaff,
//DEL 				arnote,von,bis);
//DEL 
//DEL 			curstaff->addNotationElement(grempty);
//DEL 			curmusic->addVoiceElement(arVoice,grempty);
//DEL 
//DEL 			lastev = grempty;
//DEL 
//DEL 			retval = 1;
//DEL 		} 
//DEL 		else
//DEL 		{
//DEL 
//DEL 			curev = dynamic_cast<ARMusicalEvent *>(arObject);
//DEL 
//DEL 			GRNote *grprevnote;
//DEL 			if (inmiddle && curev)
//DEL 			{
//DEL 				// inmiddle can no longer happen
//DEL 				// (GUIDO Semantic Normal Form)
//DEL 				ASSERT(FALSE);
//DEL 				
//DEL 				GObject *o = curev->getLastGRRepresentation();
//DEL 				if (o)
//DEL 				{
//DEL 					// this should not happen 
//DEL 					// because of GSNF
//DEL 					ASSERT(FALSE);
//DEL 					grprevnote = dynamic_cast<GRNote *>(o);
//DEL 					if (grprevnote->getGRStaff() != curstaff)
//DEL 						grprevnote = NULL;
//DEL 				}
//DEL 				else
//DEL 					grprevnote = NULL;
//DEL 			}
//DEL 
//DEL 			// we do not have a notefactory any longer...
//DEL 
//DEL 
//DEL 			// make sure to recognize the
//DEL 			// displayduration-tag ...
//DEL 
//DEL 			TYPE_DURATION dtempl;
//DEL 			if (curvst->curdispdur != NULL)
//DEL 			{
//DEL 				dtempl = curvst->curdispdur->getDisplayDuration();
//DEL 				int i = curvst->curdispdur->getDots();
//DEL 				TYPE_DURATION tmpdur = dtempl;
//DEL 				while (i>0)
//DEL 				{
//DEL 					// this takes care of dots
//DEL 					// maybe this should be
//DEL 					// a parameter for GRSingleNote
//DEL 					// later ...
//DEL 					tmpdur = tmpdur * DURATION_2;
//DEL 					dtempl = dtempl + tmpdur;
//DEL 					i--;
//DEL 				}
//DEL 			}
//DEL 			else
//DEL 				dtempl = curev->getDuration();
//DEL 			// we need to take care of dots!
//DEL 
//DEL 			dtempl.normalize();
//DEL 			GRNote *grnote =  new GRSingleNote(curstaff,
//DEL 				dynamic_cast<ARNote *>(curev),
//DEL 				von,bis,dtempl);
//DEL 
//DEL 			// stemdirection ...
//DEL 			// ATTENTION: to do ....
//DEL 
//DEL 			// old: GRNote *grnote = grnotefactory->createNote(
//DEL 			//	dynamic_cast<ARNote *>(arObject),von,
//DEL 			//				bis);
//DEL 
//DEL 
//DEL 			// grnotefactory aendert bis (evtl. ...)
//DEL 
//DEL 
//DEL 			// The tie has to be added bevore the
//DEL 			// note. Otherwise, the next-timeposition
//DEL 			// cannot be determined correctly.
//DEL 			if (inmiddle && grprevnote)
//DEL 			{
//DEL 				// GSNF
//DEL 				ASSERT(FALSE);
//DEL 
//DEL 				// Verbinde die aktuelle mit der
//DEL 				// vorherigen Note
//DEL 				GRTie *grtie = new  GRTie(curstaff,grprevnote,grnote);
//DEL 
//DEL /*				GRNotationElement *el = curstaff->elements->GetTail();
//DEL 				if (el)
//DEL 					grtie->setRelativeTimePosition(el->getRelativeEndTimePosition());
//DEL 				else
//DEL 					grtie->setRelativeTimePosition(curstaff->getRelativeTimePosition()); */
//DEL 
//DEL 				curstaff->addNotationElement(grtie);
//DEL 				curmusic->addVoiceElement(arVoice,grtie);
//DEL 
//DEL 			}
//DEL 			else if (inmiddle)
//DEL 			{
//DEL 				// GSNF
//DEL 				ASSERT(FALSE);
//DEL 				GRTie *grtie = new  GRTie(curstaff,NULL,grnote);
//DEL 				curstaff->addNotationElement(grtie);
//DEL 				curmusic->addVoiceElement(arVoice,grtie);
//DEL 			}
//DEL 
//DEL 
//DEL 
//DEL 			// Associate the note with the current tags ...
//DEL 			POSITION pos = grtags->GetHeadPosition();
//DEL 			while (pos)
//DEL 			{
//DEL 				GRNotationElement *el = 
//DEL 					dynamic_cast<GRNotationElement *>(grtags->GetNext(pos));
//DEL 				if (el)
//DEL 					el->addAssociation(grnote);
//DEL 			}
//DEL 
//DEL 			curstaff->addNotationElement(grnote);
//DEL 			curmusic->addVoiceElement(arVoice,grnote);
//DEL 
//DEL 			lastev = grnote;
//DEL 
//DEL 			retval = 1;
//DEL 		}
//DEL 
//DEL 	}
//DEL 	else if (ti == typeid(class ARRest))
//DEL 	{
//DEL 
//DEL 		
//DEL 		// Rests can have 0 Durations!
//DEL 		// but they are note handled correctly within
//DEL 		// tuplets ... 
//DEL 		// just ignore them for now
//DEL 
//DEL 		if (bis <= DURATION_0)
//DEL 		{
//DEL 			;
//DEL 		}
//DEL 		else
//DEL 		{
//DEL 			curev = dynamic_cast<ARMusicalEvent *>(arObject);
//DEL 			TYPE_DURATION olddur = bis;
//DEL 
//DEL 			// this is old:
//DEL 			//GRRest *grrest = grnotefactory->createRest(
//DEL 			//	dynamic_cast<ARRest *>(arObject),von,
//DEL 			//	bis);
//DEL 
//DEL 			// this is new:
//DEL 			TYPE_DURATION dtempl;
//DEL 			if (curvst->curdispdur != NULL)
//DEL 			{
//DEL 				dtempl = curvst->curdispdur->getDisplayDuration();
//DEL 				int i = curvst->curdispdur->getDots();
//DEL 				TYPE_DURATION tmpdur = dtempl;
//DEL 				while (i>0)
//DEL 				{
//DEL 					// this takes care of dots
//DEL 					// maybe this should be
//DEL 					// a parmaeter for GRSingleNote
//DEL 					// later ...
//DEL 					tmpdur = tmpdur * DURATION_2;
//DEL 					dtempl = dtempl + tmpdur;
//DEL 					i--;
//DEL 				}
//DEL 			}
//DEL 			else
//DEL 				dtempl = curev->getDuration();
//DEL 			// we need to take care of dots!
//DEL 
//DEL 			dtempl.normalize();
//DEL 
//DEL 			GRRest *grrest = new GRSingleRest(curstaff,
//DEL 				dynamic_cast<ARRest *>(curev),
//DEL 				von,bis,dtempl);
//DEL 
//DEL 			if (grrest &&
//DEL 				beginofmeasure &&
//DEL 				lastendofmeasure && 
//DEL 				olddur == bis)
//DEL 			{
//DEL 				// the created rest goes over the whole
//DEL 				// measure 
//DEL 				grrest->setWholeMeasure(1);
//DEL 			}
//DEL 			
//DEL 			
//DEL 			// Associate the rest with the current tags ...
//DEL 			POSITION pos = grtags->GetHeadPosition();
//DEL 			while (pos)
//DEL 			{
//DEL 				GRNotationElement *el = 
//DEL 					dynamic_cast<GRNotationElement *>(grtags->GetNext(pos));
//DEL 				if (el)
//DEL 					el->addAssociation(grrest);
//DEL 			}
//DEL 			
//DEL 			curstaff->addNotationElement(grrest);
//DEL 			curmusic->addVoiceElement(arVoice,grrest);
//DEL 			
//DEL 			lastev = grrest;
//DEL 			
//DEL 			retval = 1;
//DEL 		}
//DEL 	}
//DEL 	else if (ti == typeid(class ARChord))
//DEL 	{
//DEL 
//DEL 		if (bis>DURATION_0)
//DEL 		{
//DEL 
//DEL 			ARChord *chord = dynamic_cast<ARChord *>
//DEL 				(arObject);
//DEL 
//DEL 
//DEL 			GRChord *grprevchord = NULL;
//DEL 			if (inmiddle)
//DEL 			{
//DEL 				ASSERT(FALSE);
//DEL 				grprevchord = dynamic_cast<GRChord *>(chord->getLastGRRepresentation());
//DEL 				if (grprevchord->getGRStaff() != curstaff)
//DEL 					grprevchord = NULL;
//DEL 			}
//DEL 
//DEL 
//DEL 			// old:
//DEL 			//GRChord *grchord = grnotefactory->createChord(
//DEL 			//	chord,von,bis);
//DEL 
//DEL 			// new:
//DEL 			TYPE_DURATION dtempl;
//DEL 			if (curvst->curdispdur != NULL)
//DEL 			{
//DEL 				dtempl = curvst->curdispdur->getDisplayDuration();
//DEL 				int i = curvst->curdispdur->getDots();
//DEL 				TYPE_DURATION tmpdur = dtempl;
//DEL 				while (i>0)
//DEL 				{
//DEL 					// this takes care of dots
//DEL 					// maybe this should be
//DEL 					// a parmaeter for GRSingleNote
//DEL 					// later ...
//DEL 					tmpdur = tmpdur * DURATION_2;
//DEL 					dtempl = dtempl + tmpdur;
//DEL 					i--;
//DEL 				}
//DEL 			}
//DEL 			else
//DEL 				dtempl = chord->getDuration();
//DEL 			// we need to take care of dots!
//DEL 
//DEL 			dtempl.normalize();
//DEL 			GRChord *grchord = new GRChord(curstaff,chord,
//DEL 					von,bis,dtempl);
//DEL 
//DEL 	
//DEL 			// The tie has to be added bevore the
//DEL 			// note. Otherwise, the next-timeposition
//DEL 			// cannot be determined correctly.
//DEL 			if (inmiddle && grprevchord)
//DEL 			{
//DEL 				ASSERT(FALSE);
//DEL 				// Verbinde die aktuelle mit der
//DEL 				// vorherigen Note
//DEL 				GRTie *grtie = new  GRTie(curstaff,grprevchord,grchord);
//DEL 				curstaff->addNotationElement(grtie);
//DEL 				curmusic->addVoiceElement(arVoice,grtie);
//DEL 
//DEL 			}
//DEL 			else if (inmiddle)
//DEL 			{
//DEL 				ASSERT(FALSE);
//DEL 				GRTie *grtie = new  GRTie(curstaff,NULL,grchord);
//DEL 				curstaff->addNotationElement(grtie);
//DEL 				curmusic->addVoiceElement(arVoice,grtie);
//DEL 			}
//DEL 
//DEL 
//DEL 			// Associate the rest with the current tags ...
//DEL 			POSITION pos = grtags->GetHeadPosition();
//DEL 			while (pos)
//DEL 			{
//DEL 				GRNotationElement *el = 
//DEL 					dynamic_cast<GRNotationElement *>
//DEL 					(grtags->GetNext(pos));
//DEL 				if (el)
//DEL 					el->addAssociation(grchord);
//DEL 			}
//DEL 
//DEL 			curstaff->addNotationElement(grchord);
//DEL 			curmusic->addVoiceElement(arVoice,grchord);
//DEL 
//DEL 			lastev = grchord;
//DEL 
//DEL 			retval = 1;
//DEL 
//DEL 		}
//DEL 
//DEL 
//DEL 	}
//DEL 	else if (ti == typeid(class ARNewSystem))
//DEL 	{
//DEL 
//DEL 		retval = -1;
//DEL 
//DEL 	}
//DEL 	else if (ti == typeid(class ARNewPage))
//DEL 	{
//DEL 
//DEL 		retval = -2;
//DEL 
//DEL 	}
//DEL 	else if (ti == typeid(class ARStaffOff))
//DEL 	{
//DEL 		retval = -5;
//DEL 	}
//DEL 	else if (parseTag(arObject))
//DEL 	{
//DEL 		// parse Handled the Tag.
//DEL 
//DEL 		// 
//DEL 
//DEL 		// no new timeposition !
//DEL 		retval = 0;
//DEL 	}
//DEL 	else
//DEL 	{
//DEL 		// maybe warning ....
//DEL 
//DEL 		// no new timeposition!
//DEL 		retval = 0;
//DEL 	}
//DEL 
//DEL 	// if the note has been done completly ....
//DEL 	if (von + bis == arObject->getRelativeEndTimePosition())
//DEL 	{
//DEL 		// this closes up the open position tags ....
//DEL 
//DEL 		// old version : -> check here
//DEL 		// checkEndPTags(pos);
//DEL 
//DEL 		POSITION prevpos = pos;
//DEL 
//DEL 		arVoice->GetNext(pos,*curvst);	
//DEL 
//DEL 		// new version check now ...
//DEL 		if (curvst->removedpositiontags)
//DEL 		{
//DEL 			checkEndPTags(prevpos);
//DEL 		}
//DEL 	} 
//DEL 
//DEL 	return retval;
//DEL 
//DEL }

void GRVoiceManager::EndManageVoice(const TYPE_TIMEPOSITION &tp)
{

	ASSERT(FALSE);

	POSITION pos = curvst->vpos;

	ARMusicalObject *arObject;
	TYPE_DURATION cutDuration;

	// Cut am Staff-Ende
	// pruefe, ob wir am Ende weiter gehen koennen,
	// oder nicht!
	
	int iscut = 0;
	if (pos)
	{
		arObject = arVoice->GetAt(pos);
		if (arObject->getRelativeTimePosition()>tp)
			iscut = 1;
	}
	else
	{
		arObject = arVoice->GetTail();
		if (arObject && arObject->getRelativeEndTimePosition()>tp)
			iscut = 1;
	}

	if (iscut)
	{
		
		// now, we have back up one position
		// and ADJUST POSITION-Tags!
		// Lucky that we know, that the given 
		// Object can only be an Event and not
		// a tag!
		
		arVoice->GetPrevEvent(curvst->vpos,*curvst);
		
		
		// adjust graphical elements ...
		// add ties ....
		
		ARMusicalObject *ar = arVoice->GetAt(curvst->vpos);
		
		
		
		if (ar)
		{
			GObject *o = ar->getLastGRRepresentation();
			
			if (o)
			{
				GREvent *g = 
					dynamic_cast<GREvent *>(o);
				
				
				// must be a notation element!
				ASSERT(g);
				
				// Now tell the Event, that its length 
				// needs to be changed ...
				TYPE_DURATION tmpdur = tp - g->getRelativeTimePosition();
				int ret = g->adjustLength(tmpdur);
				
				if (ret != 1)
				{ // Deal with it!
					// an error occured?
					// no complete match!
				}
				
				// OK -> the tags, that were previously ended
				// and are now open-ranged need to know,
				// that there previos ending-element is no longer
				// right now, I believe that all this works
				// (as follows):
				// These Ranges are now in the ptaglist, that
				// have an end-position, that matches the
				// current-position. -> now put them in the
				// grtags, so that stafffinished is called for
				// them.
				
				NEPointerList *mylst = g->getAssociations();
				if (mylst)
				{
					// now, what do we have ...
					POSITION pos = mylst->GetHeadPosition();
					while (pos)
					{
						GRTag *thetag = dynamic_cast
							<GRTag *>(mylst->GetNext(pos));
						GRPositionTag *mytag = 
							dynamic_cast<GRPositionTag *>(thetag);
						if (mytag
							&& mytag->getEndPos() == curvst->vpos)
						{
							addGRTag(thetag,0);
						}
					}
				}
				
				// if it is not a rest, a tie is added
				// (with open right range)
				if (!dynamic_cast<GRRest *>(g))
				{
					GRTie *grtie = new GRTie(curstaff,g,NULL);
					grtie->setRelativeTimePosition(tp);
					curstaff->addNotationElement(grtie);
					curmusic->addVoiceElement(arVoice,grtie);
				}
				
				// now, if the Event was the End of 
				// a Position Tag, we need to tell those
				// tags, that they have now openRightRanges!
				
			}
		}
		
	}

	//if(pos && arVoice->GetAt(pos)->getRelativeTimePosition()<staffmgr->getRelativeEndTimePosition())
	//{

		/* Rethink all of this ...

		arObject=arVoice->GetAt(pos);
		cutDuration=staffmgr->getRelativeEndTimePosition()-arObject->getRelativeTimePosition();
		GRNote *tmp = curstaff->createCutStaffElement(arObject,
			arObject->getRelativeTimePosition(),cutDuration,grnotefactory);
		if (tmp)
		 {
		 GRTie *tie = tmp->AddHalfTie();
		 curstaff->elements->AddTail(tie);
		 }
		 */
	// }

	// Hier wird der Tuplet-State der Notefactory uebernommen

	// Attention, this does not make sense -> tuplets
	// are to be saved in the voice-state
	
	// no more notefactory (GSNF)
	//GRTupletState mytplstate;
	//if (grnotefactory->                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   